global VCLayers, VCLayerDialog, VCLayerRollout, VCLayerAdjustementDialog

fn reloadBitmapfn bm = (
	forceReloadBitmapFile bm
	VCLoadBitmapIntoLayer bm	
)

rcmenu VCLayerFileMenu
(
	menuitem item1 ~SAVE_PSD_AS_CAPTION~
	menuitem item2 ~SAVE_BITMAP_FLATTENED_AS~
	separator sepp0
	menuitem item3 ~LOAD_BITMAP_INTO_CURRENT_LAYER~
	menuitem item4 ~PASTE_FROM_CLIPBOARD~
	
	on item1 picked do
	(
		filename = getSaveFileName caption:~FILENAME_SAVE_PSD_AS_CAPTION~ filename:"" types:"PSD(*.psd)|*.psd"
		if filename != undefined and filename != "" do
		(
			VCSavePSD filename
		)
	)
	on item2 picked do
	(
		filename = getSaveFileName caption:~SAVE_BITMAP_FLATTENED_AS_CAPTION~ filename:"" types:"TIFF(*.tif)|*.tif|BMP (*.bmp)|*.bmp|Targa (*.tga)|*.tga|PNG (*.png)|*.png|JPEG (*.jpg)|*.jpg"
		if filename != undefined and filename != "" do
		(
			if (doesFileExist filename and getFileAttribute filename #readOnly) do
			(
				setFileAttribute filename #readOnly false
			)
			texWidth = VCGetSetting 101
			texHeight = VCGetSetting 102
			tex = bitmap texWidth texHeight
			result = VCFillInBitmap tex
			tex.filename = filename
			save tex
			close tex
		)
	)
	on item3 picked do
	(
		tex = selectBitmap caption:~LOAD_BITMAP_INTO_CURRENT_LAYER_CAPTION~
		if tex != undefined do
		(
			VCLoadBitmapIntoLayer tex
			registerFileChangedFunction  tex reloadBitmapfn
			close tex
		)
	)
	on item4 picked do
	(
		VCPasteFromClipboard()
	)
)
rcmenu VCLayerDockMenu
(
	menuitem item1 ~DOCK_LEFT~ enabled:(not VCLayerDialog.dialogBar or (VCLayerDialog.dialogBar and (cui.getDockState VCLayerDialog != #cui_dock_left)))
	menuitem item2 ~DOCK_RIGHT~ enabled:(not VCLayerDialog.dialogBar or (VCLayerDialog.dialogBar and (cui.getDockState VCLayerDialog != #cui_dock_right)))
	menuitem item3 ~FLOAT~ enabled:(VCLayerDialog.dialogBar and (cui.getDockState VCLayerDialog) != #cui_floatable)
	fn DockDialog type =
	(
		if (not VCLayerDialog.dialogBar) do
		(
			VCLayers.LayerDialogHeightBeforeDock = (getDialogSize VCLayerDialog).y
			VCLayerDialog.height = VCLayers.GetViewHeight() + 22
			cui.RegisterDialogBar VCLayerDialog style:#(#cui_floatable, #cui_dock_horz) minSize:[220,100] maxSize:[220,1600]
		)
		cui.DockDialogBar VCLayerDialog type
		VCLayers.LayerDialogDockState = type
	)
	on item1 picked do DockDialog #cui_dock_left
	on item2 picked do DockDialog #cui_dock_right
	on item3 picked do
	(
		if VCLayerDialog.dialogBar and ((cui.getDockState VCLayerDialog) != #cui_floatable) do
		(
			cui.FloatDialogBar VCLayerDialog
			cui.UnRegisterDialogBar VCLayerDialog
			VCLayerDialog.height = VCLayers.LayerDialogHeightBeforeDock
			VCLayers.LayerDialogDockState = #cui_floatable
		)
	)
)
rcmenu VCLayerActionsMenu
(
	fn maskAddFilter =
	(
		index = VCGetLayerSetting 2 0
		(not (VCGetLayerSetting 7 index) and (index != 1))
	)
	fn hasMaskFilter =
	(
		index = VCGetLayerSetting 2 0
		VCGetLayerSetting 7 index
	)
	fn maskEnabledFilter =
	(
		index = VCGetLayerSetting 2 0
		hasMaskFilter() and not (VCGetLayerSetting 10 index)
	)
	fn maskDisabledFilter =
	(
		index = VCGetLayerSetting 2 0
		hasMaskFilter() and (VCGetLayerSetting 10 index)
	)
	fn showMaskItems =
	(
		maskAddFilter() or hasMaskFilter()
	)
	menuitem itemRename ~RENAME_LAYER~
	separator sepp0
	submenu ~ADD_LAYER_MASK~ filter:maskAddFilter
	(
		menuitem itemRevealAll ~REVEAL_ALL~
		menuitem itemHideAll ~HIDE_ALL~
	)
	menuitem itemDisableMask ~DISABLE_LAYER_MASK~ filter:maskEnabledFilter
	menuitem itemEnableMask ~ENABLE_LAYER_MASK~ filter:maskDisabledFilter
	menuitem itemDeleteMask ~DELETE_LAYER_MASK~ filter:hasMaskFilter
	separator sepp1 filter:showMaskItems
	menuitem itemNew ~NEW_LAYER~
	menuitem itemDuplicate ~DUPLICATE_LAYER~
	menuitem itemDelete ~DELETE_LAYER_CAPTION~
	separator sepp2
	menuItem itemMergeDown ~MERGE_DOWN_CAPTION~
	menuItem itemApplyImage ~APPLY_IMAGE~
	menuItem itemFlatten ~FLATTEN_VISIBLE_LAYER~
	separator sepp3
	menuItem itemFlipHorizontal ~FLIP_HORIZONTAL~
	menuItem itemFlipVertical ~FLIP_VERTICAL~
	
	on itemRename picked do VCLayers.RenameLayer (VCGetLayerSetting 2 0)
	on itemRevealAll picked do
	(
		VCAddMask true
		VCLayers.UpdateLayerUI()
	)
	on itemHideAll picked do
	(
		VCAddMask false
		VCLayers.UpdateLayerUI()
	)
	on itemDisableMask picked do
	(
		index = VCGetLayerSetting 2 0
		VCSetLayerSetting 10 index true
		VCLayers.SetLayerImage index false false
	)
	on itemEnableMask picked do
	(
		index = VCGetLayerSetting 2 0
		VCSetLayerSetting 10 index false
		VCLayers.SetLayerImage index false false
	)
	on itemDeleteMask picked do VCDeleteMask()
	on itemNew picked do VCNewLayer()
	on itemDuplicate picked do VCDuplicateLayer()
	on itemDelete picked do VCDeleteLayer()
	on itemMergeDown picked do VCMergeDownLayer()
	on itemApplyImage picked do VCApplyImage()
	on itemFlatten picked do VCFlattenLayers()
	on itemFlipHorizontal picked do VCFlipLayer true
	on itemFlipVertical picked do VCFlipLayer false
)
rcmenu VCLayerAdjustMenu
(

	menuItem itemAdjust ~BRIGHTNESS_CONTRAST_HUE_SATURATION~
	menuItem itemLevels ~LEVELS_CAPTION~
	menuItem itemColorBalance ~COLOR_BALANCE~
	menuItem itemNormalize ~AUTO_LEVELS~
	menuItem itemInvert ~INVERT~
	
	on itemAdjust picked do VCLayers.OpenAdjustmentDialog()
	on itemLevels picked do VCLayers.OpenLevelsDialog()
	on itemColorBalance picked do VCLayers.OpenColorBalanceDialog()
	on itemNormalize picked do VCNormalize()
	on itemInvert picked do VCInvertLayer()
)
rcmenu VCLayerFilterMenu
(
	menuItem itemBlur ~BLUR~
	menuItem itemSharpen ~SHARPEN~
	menuItem itemFindEdges ~FIND_EDGES~
	menuItem itemMedian ~MEDIAN~
	menuItem itemThreshold ~THRESHOLD~
	menuItem itemHighPass ~HIGH_PASS~
	menuItem itemJitter ~DISTORT~
	
	on itemBlur picked do VCLayers.OpenBlurDialog()
	on itemSharpen picked do VCLayers.OpenSharpenDialog()
	on itemFindEdges picked do VCLayers.OpenFindEdgesDialog()
	on itemMedian picked do VCLayers.OpenMedianDialog()
	on itemThreshold picked do VCLayers.OpenThresholdDialog()
	on itemHighPass picked do VCLayers.OpenHighPassDialog()
	on itemJitter picked do VCLayers.OpenJitterDialog()
)
rcmenu VCLayerMenu
(
	menuItem item1 ~FILE~
	menuItem item2 ~LAYER~
	menuItem item3 ~ADJUST~
	menuItem item4 ~FILTER~
	menuItem item5 ~DOCK~
	
	on item1 picked do (popUpMenu VCLayerFileMenu pos:[0,0] rollout:VCLayerDialog)
	on item2 picked do (popUpMenu VCLayerActionsMenu pos:[28,0] rollout:VCLayerDialog)
	on item3 picked do (popupMenu VCLayerAdjustMenu pos:[68,0] rollout:VCLayerDialog)
	on item4 picked do (popupMenu VCLayerFilterMenu pos:[112,0] rollout:VCLayerDialog)
	on item5 picked do (popupMenu VCLayerDockMenu pos:[150,0] rollout:VCLayerDialog)
)
struct VCLayerStruct
(
LayerVisibleBitmap = undefined,
LayerEmptyBitmap = undefined,
LayerSelectedBitmap = undefined,
LayerDialogPos = [100,300],
LayerDialogSize = [240, 220],
LayerDialogHeightBeforeDock = 220,
LayerDialogLeftOpen = true,
LayerMouseVisibilityDown = 0,
LayerDragDown = 0,
LayerDialogDockState = #cui_floatable,
LayerFillBitmap = undefined,
fn BuildLayerRollout =
(
	numLayers = VCGetLayerSetting 1 0
	rollString = ~ROLLSTRING~
	
	for i = numLayers to 1 by -1 do
	(
		index = i as string
		if i == numLayers then fillOffsetY = "-5"
		else fillOffsetY = "4"
		imgOffsetY = "-9"
		layerName = VCGetLayerSetting 8  i
		rollString += "bitmap layerFill" + index  + " \"" +  index + "\" width:200 height:1 offset:[0," +fillOffsetY + "] visible:false align:#center\n"
		rollString += "imgtag layerImg" + index  + " \"" +  index + "\" width:200 height:36 offset:[0," + imgOffsetY + "] align:#center transparent:[255,0,255] \n"
		rollString += "hyperLink laylab" + index + " \"" + layerName + "\" align:#left offset:[50,-29] enabled:false \n"
		rollString += "on layerImg" + index + " lbuttondown pos flags do (VCLayers.LayerClick " + index + " pos true) \n"
		rollString += "on layerImg" + index + " lbuttonup pos flags do VCLayers.LayerClickRelease() \n"
		rollString += "on layerImg" + index + " mouseover pos flags do VCLayers.CheckVisibilityDrag " + index + " \n"
		rollString += "on layerImg" + index + " rbuttondown pos flags do (VCLayers.LayerClick " + index + " pos false ; popupMenu VCLayerActionsMenu) \n"
		rollString += "on layerImg" + index + " lbuttondblclk pos flags do (if (pos.x > 52 and pos.x < 167) do VCLayers.RenameLayer " + index + ") \n"
	)
	rollString += ")"
	execute rollString
),
fn UpdateLayerUI =
(
	--enable or disable UI depending on what layer is selected
	currentLayer = VCGetLayerSetting 2 0
	
	if (currentLayer == 1) then
	(
		VCLayerDialog.opacspin.enabled = false
		VCLayerDialog.blendmode.enabled = false
		VCLayerDialog.deletelayerbut.enabled = false
	)
	else
	(
		VCLayerDialog.opacspin.enabled = true
		VCLayerDialog.blendmode.enabled = true
		VCLayerDialog.deletelayerbut.enabled = true
	)
	VCLayerDialog.opacspin.value = VCGetLayerSetting 4 currentLayer
	VCLayerDialog.blendmode.selection = VCGetLayerSetting 5 currentLayer
),
fn TruncateNameText txt =
(
	textSize = getTextExtent txt
	if textSize.x > 102 do
	(
		letterCount = txt.count
		tempName = ""
		for i = 1 to letterCount do
		(
			if (getTextExtent tempName).x > 88 do exit
			tempName += txt[i]
		)
		tempName += "..."
		txt = tempName
	)
	txt
),
fn SetLayerImage index selectLayer updateLastLayer =
(
	currentGamma = IDisplayGamma.colorCorrectionMode
	IDisplayGamma.colorCorrectionMode = #none
	
	numLayers = VCGetLayerSetting 1 0
	currentLayer = VCGetLayerSetting 2 0
	if selectLayer do
	(
		VCSetCurrentLayer index
		UpdateLayerUI()
	)
	controlCount = VCLayerRollout.controls.count
	controlArr = #()
	labelArr = #()
	for i = controlCount to 1 by -1 do
	(
		if (classof VCLayerRollout.controls[i] == ImgTag) then append controlArr VCLayerRollout.controls[i] 
		else if (classof VCLayerRollout.controls[i] == LinkControl) do append labelArr VCLayerRollout.controls[i] 
	)
	backColor = (colorMan.getColor #background ) * 255
	if (VCGetLayerSetting 2 0) == index then --layer is selected
	(
		selColor = backColor - [22,22,22]
		if selColor.x < 0 do selColor.x = 0
		if selColor.y < 0 do selColor.y = 0
		if selColor.z < 0 do selColor.z = 0
		layerImage = bitmap 200 36 color:selColor
	)
	else layerImage = bitmap 200 36 color:backColor
	newName = VCSetLayerBitmap index layerImage LayerVisibleBitmap LayerEmptyBitmap LayerSelectedBitmap false
	labelArr[index].text = TruncateNameText newName
	controlArr[index].bitmap = layerImage
	if updateLastLayer and currentLayer != index do
	(
		layerImage2 = bitmap 200 36 color:backColor
		newName = VCSetLayerBitmap currentLayer layerImage2 LayerVisibleBitmap LayerEmptyBitmap LayerSelectedBitmap true
		labelArr[currentLayer].text = TruncateNameText newName
		controlArr[currentLayer].bitmap = layerImage2
	)
	IDisplayGamma.colorCorrectionMode = currentGamma
),
fn UpdateLayers =
(
	if (VCLayerDialog.theSubRollout.rollouts.count != 0) do
	(
		removeSubRollout VCLayerDialog.theSubRollout VCLayerRollout
		VCLayerRollout = undefined
	)
	BuildLayerRollout()
	numLayers = VCGetLayerSetting 1 0
	beforepos = getDialogPos VClayerDialog
	newHeight = 220 + ((numLayers - 3) * 37)
	if newHeight > (sysInfo.desktopSize.y - 400) do newHeight = sysInfo.desktopSize.y - 400
	if newHeight < VCLayers.LayerDialogSize.y do  newHeight = VCLayers.LayerDialogSize.y
	if numLayers > 3 do
	(
		if not VClayerDialog.dialogbar then
		(
			midpos = getDialogPos VClayerDialog
			diffpos = beforepos - midpos
			VCLayerDialog.height = newHeight
		)
	)
	addSubRollout VCLayerDialog.theSubRollout VCLayerRollout
	diagSize = GetDialogSize VCLayerDialog
	VCLayerDialog.theSubRollout.height = diagSize.y - 70
	
	--create the fill bitmap between each layer which is visible when reordering layer by dragging
	controls = VCLayerRollout.controls
	for i = 1 to controls.count do 
	(
		cont = VCLayerRollout.controls[i]
		if (classof cont == BitmapControl) do VCLayerRollout.controls[i].bitmap = LayerFillBitmap
	)
	
	for i = 1 to numLayers do
	(
		SetLayerImage i false false
	)
	UpdateLayerUI()
),
fn CheckVisibilityDrag index =
(
	if LayerDragDown != 0 and (not VCIsLeftButtonDown()) do --if user starts to reorder layer and releases mouse outside UI
	(
		LayerDragDown = 0
		controls = VCLayerRollout.controls
		for i = 1 to controls.count do
		(
			if (classof controls[i] == BitmapControl) do controls[i].visible = false
		)
	)
	
	--If mouse has been clicked on visibility icon change on the other layers to the same state while mouse is down and they are dragged over
	if LayerMouseVisibilityDown > 0 then
	(
		if LayerMouseVisibilityDown == 1 then VCSetLayerSetting 6 index false
		else VCSetLayerSetting 6 index true
		SetLayerImage index false false
	)
	else if LayerDragDown != 0 and index > 1 do --display filler image between layers that indicates where to move a layer
	(
		numLayers = VCGetLayerSetting 1 0
		currentLayer = VCGetLayerSetting 2 0
		if currentLayer != 1 and numLayers > 2 do
		(
			controlCount = VCLayerRollout.controls.count
			fillerArr = #()
			for i = controlCount to 1 by -1 do
			(
				if (classof VCLayerRollout.controls[i] == BitmapControl) do
				(
					append fillerArr VCLayerRollout.controls[i]
					VCLayerRollout.controls[i].visible = false
				)
			)
			if index > currentLayer then
			(
				fillerArr[index].visible = true
				LayerDragDown = index
			)
			else if index < currentLayer and index != 1 then
			(
				fillerArr[index-1].visible = true
				LayerDragDown = index - 1
			)
			else LayerDragDown = index
		)
	)
),
fn LayerClickRelease =
(
	LayerMouseVisibilityDown = 0
	currentLayer = VCGetLayerSetting 2 0
	if LayerDragDown != 0 and LayerDragDown != currentLayer do
	(
		VCMoveLayer LayerDragDown
	)
	LayerDragDown = 0
),
fn LayerClick index pos allowDrag =
(
	if (pos.x < 21 and pos.y > 6 and pos.y < 29) then --Change the isVisible state
	(
		currentVisible = VCGetLayerSetting 6 index
		if currentVisible then LayerMouseVisibilityDown = 1
		else LayerMouseVisibilityDown = 2
		VCSetLayerSetting 6 index (not currentVisible)
		SetLayerImage index false false
	)
	else if ((VCGetLayerSetting 7 index) and pos.x > 166 and pos.x < 195 and pos.y > 3 and pos.y < 32) then --Select layer mask thumbnail
	(
		VCSetLayerSetting 3 index true --turn on mask painting
		if (VCGetLayerSetting 10 index) do VCSetLayerSetting 10 index false --enable layer mask if it is disabled
		SetLayerImage index true true
	)
	else
	(
		currentLayer = VCGetLayerSetting 2 0
		if allowDrag do LayerDragDown = index
		if (currentLayer != index) or (pos.x > 22 and pos.x < 51 and pos.y > 3 and pos.y < 32) then --Select layer thumbnail
		(
			VCSetLayerSetting 3 index false
		)
		SetLayerImage index true true
	)
),
fn SetLayerUIName index =
(
	layerName = VCGetLayerSetting 8 index
	newName = TruncateNameText layerName
	execute ("VCLayerRollout.laylab" + (index as string) + ".text = \"\"")
	execute ("VCLayerRollout.laylab" + (index as string) + ".text = \"" + newName + "\"")
),
fn RenameLayer index =
(
	global VCRenameIndex = index
	global VCRenameLayerText = VCGetLayerSetting 8 index
	rollout VCRenameLayerRoll ~ROLLOUT_RENAME_LAYER~
	(
		edittext nametext ~NAMETEXT~ fieldWidth:205 text:VCRenameLayerText
		button okbut ~OK~ width:50 align:#right offset:[-60,0]
		button cancelbut ~CANCEL~ width:50 align:#right offset:[0,-26]
		
		on nametext entered txt do
		(
			if (txt == "") do nametext.text = VCRenameLayerText
		)
		on okbut pressed do
		(
			newName = nametext.text
			nameres = try(execute ("nameTest = \"" + newName + "\""))catch(undefined) --check that the name is a valid string
			if nameres != undefined then
			(
				if (newName == "") do newName = VCRenameLayerText
				VCLayerSettingChangeStart ~LAYER_NAME_CHANGE~ --create undo entry
				VCSetLayerSetting 8 VCRenameIndex newName
				
				--Set the layer label text
				newName = TruncateNameText newName
				execute ("VCLayerRollout.laylab" + (VCRenameIndex as string) + ".text = \"\"")
				execute ("VCLayerRollout.laylab" + (VCRenameIndex as string) + ".text = \"" + newName + "\"")
				
				destroyDialog VCRenameLayerRoll 
			)
			else messagebox ~MSGBOX_NOT_A_VALID_LAYER_NAME~ title:~RENAME_LAYER_TITLE~
		)
		on cancelbut pressed do destroyDialog VCRenameLayerRoll 
	)
	diagpos = getDialogPos VCLayerDialog
	createDialog VCRenameLayerRoll 270 60 diagpos.x (mouse.screenpos.y - 110) modal:true
),
fn GetViewHeight =
(
	numviews = viewport.numViews
	viewlayout = viewport.getLayout()
	activeview = viewport.activeViewport
	theHeight = 0
	if numviews == 1 then theHeight = (getViewSize()).y
	else if numviews == 2 then
	(
		if viewlayout == #layout_2v then theHeight = (getViewSize()).y
		else
		(
			viewport.activeViewport = 1
			theHeight = (getViewSize()).y
			viewport.activeViewport = 2
			theHeight += (getViewSize()).y
			theHeight += 8
			viewport.activeViewport = activeview
		)
	)
	else if numviews == 3 then
	(
		viewport.activeViewport = 1
		size1 = getViewSize()
		viewport.activeViewport = 2
		size2 = getViewSize()
		viewport.activeViewport = 3
		size3 = getViewSize()
		viewport.activeViewport = activeview
		
		if viewlayout == #layout_3vl or viewlayout == #layout_3vr then
		(
			if size1.y > size2.y  then
			(
				if size1.y  > size3.y  then theHeight = size1.y 
				else theHeight = size3.y 
			)
			else if size2.y  > size3.y  then theHeight = size2.y 
			else theHeight = size3.y 
		)
		else
		(
			if size1.x > size2.x then
			(
				if size1.x  > size3.x  then theHeight = size1.y + size2.y + 8
				else theHeight = size3.y + size1.y + 8
			)
			else if size2.x  > size3.x  then theHeight = size2.y + size1.y + 8
			else theHeight = size3.y + size1.y + 8
		)
	)
	else -- 4 views
	(
		viewport.activeViewport = 1
		size1 = getViewSize()
		viewport.activeViewport = 2
		size2 = getViewSize()
		viewport.activeViewport = 3
		size3 = getViewSize()
		viewport.activeViewport = 4
		size4 = getViewSize()
		viewport.activeViewport = activeview
		
		if viewlayout == #layout_4 then
		(
			theHeight = (size1.y + size2.y + size3.y + size4.y) / 2.0
			theHeight += 8
		)
		else if viewlayout == #layout_4vl or viewlayout == #layout_4vr then --three small on sides, get biggest
		(
			theHeight = size1.y
			if size2.y > theHeight do theHeight = size2.y
			if size3.y > theHeight do theHeight = size3.y
			if size4.y > theHeight do theHeight = size4.y
		)
		else -- three views on top or bottom
		(
			biggestWidthIndex = 1
			biggestWidth = size1.x
			if size2.x > biggestWidth do (biggestWidth = size2.x ; biggestWidthIndex = 2)
			if size3.x > biggestWidth do (biggestWidth = size3.x ; biggestWidthIndex = 3)
			if size4.x > biggestWidth do (biggestWidth = size4.x ; biggestWidthIndex = 4)
			if biggestWidthIndex == 1 then theHeight = size1.y + size2.y + 8
			else if biggestWidthIndex == 2 then theHeight = size2.y + size1.y + 8
			else if biggestWidthIndex == 3 then theHeight = size3.y + size2.y + 8
			else theHeight = size4.y + size1.y + 8
		)
	)
	theHeight
),
fn SaveBitmapDialog enableContinue =
(
	global doEnableContinue = enableContinue
	rollout VCSaveDialog ~SAVE_TEXTURE_LAYERS~
	(
		local hasPressedButton = false
		label savlab ~LAYERS_ADDED_TO_IMAGE~
		label savlab2 ~CHOOSE_YOUR_ACTION~
		button savbut0 ~CONTINUE_PAINTING_BUTTONTEXT~ width:~CONTINUE_PAINTING_WIDTH~ offset:[0,6] enabled:doEnableContinue
		button savbut1 ~SAVE_AS_PSD_FILE~ width:~SAVE_AS_PSD_FILE_WIDTH~ offset:[0,6]
		button savbut2 ~FLATTEN_LAYERS_SAVE_CURRENT_TEXTURE~ width:~FLATTEN_LAYERS_SAVE_CURRENT_TEXTURE_WIDTH~ offset:[0,6]
		button savbut3 ~SAVE_AS_PSD_REPLACE_TEXTURE~ width:~SAVE_AS_PSD_REPLACE_TEXTURE_WIDTH~ offset:[0,6]
		button savbut4 ~SAVE_PSD_FLATTEN_LAYERS~ width:~SAVE_PSD_FLATTEN_LAYERS_WIDTH~ offset:[0,6]
		button savbut5 ~DISCARD_PAINT~ width:~DISCARD_PAINT_WIDTH~ offset:[0,6]
		
		on savbut0 pressed do
		(
			hasPressedButton = true
			destroyDialog VCSaveDialog
		)
		on savbut1 pressed do
		(
			filename = getSaveFileName caption:~SAVE_PSD_AS_CAPTION2~ filename:"" types:"PSD(*.psd)|*.psd"
			if filename != undefined and filename != "" do
			(
				VCSavePSD filename
				VCSetSetting 11 false
				ViewportCanvasEnd()
				VCSetSetting 11 true
				hasPressedButton = true
				destroyDialog VCSaveDialog
			)
		)
		on savbut2 pressed do
		(
			VCFlattenLayersNoUndo()
			ViewportCanvasEnd()
			hasPressedButton = true
			destroyDialog VCSaveDialog
		)
		on savbut3 pressed do
		(
			filename = getSaveFileName caption:~SAVE_PSD_AS_CAPTION3~ filename:"" types:"PSD(*.psd)|*.psd"
			if filename != undefined and filename != "" do
			(
				VCSavePSD filename
				
				VCSetSetting 11 false
				ViewportCanvasEnd()
				VCSetSetting 11 true
				
				VCanvas.endMapslotSearch = false
				VCanvas.usedMapSlot = undefined
				VCanvas.FindUsedMapslot $.material
				if (VCanvas.usedMapSlot != undefined) and (doesFileExist filename) do
				(
					VCanvas.usedMapSlot.bitmap = openbitmap filename
					VCanvas.currentTextureFile = filename
				)
				hasPressedButton = true
				destroyDialog VCSaveDialog
			)
		)
		on savbut4 pressed do
		(
			filename = getSaveFileName caption:~SAVE_PSD_AS_CAPTION4~ filename:"" types:"PSD(*.psd)|*.psd"
			if filename != undefined and filename != "" do
			(
				VCSavePSD filename
				VCFlattenLayersNoUndo()
				ViewportCanvasEnd()
				hasPressedButton = true
				destroyDialog VCSaveDialog
			)
		)
		on savbut5 pressed do
		(
			VCSetSetting 11 false
			ViewportCanvasEnd()
			VCSetSetting 11 true
			hasPressedButton = true
			destroyDialog VCSaveDialog
		)
		on VCSaveDialog close do
		(
			if (not hasPressedButton) do
			(
				--turn off save and exit
				VCSetSetting 11 false
				ViewportCanvasEnd()
				VCSetSetting 11 true
			)
		)
	)
	createDialog VCSaveDialog 340 250 modal:true
),
fn OpenAdjustmentDialog =
(
	rollout VCLayerAdjustementDialog ~ADJUST_LAYER~
	(
		local hasPressedButton = false
		spinner brightspin "" fieldwidth:36 type:#integer range:[-100,100,0] align:#center offset:[26,0]
		slider brightslide ~BRIGHTNESS~ ticks:0 type:#integer range:[-100,100,0] width:200 offset:[0,-20]
		spinner contrastspin "" fieldwidth:36 type:#integer range:[-100,100,0] align:#center offset:[26,0]
		slider contrastslide ~CONTRAST~ ticks:0 type:#integer range:[-100,100,0] width:200  offset:[0,-20]
		spinner huespin "" fieldwidth:36 type:#integer range:[-180,180,0] align:#center offset:[26,0] visible:(not (VCGetLayerSetting 3 0))
		slider hueslide ~HUE~ ticks:0 type:#integer range:[-180,180,0] width:200 offset:[0,-20] visible:(not (VCGetLayerSetting 3 0))
		spinner satuspin "" fieldwidth:36 type:#integer range:[-100,100,0] align:#center offset:[26,0] visible:(not (VCGetLayerSetting 3 0))
		slider satuslide ~SATURATION~ ticks:0 type:#integer range:[-100,100,0] width:200 offset:[0,-20] visible:(not (VCGetLayerSetting 3 0))
		checkbox previewcheck ~PREVIEW~ checked:true offset:[204,-78]
		button okbut ~OK_CAPTION~ width:60 offset:[100,12]
		button cancelbut ~CANCEL_CAPTION~ width:60 offset:[100,0]
		
		on previewcheck changed state do
		(
			if state then VCLayerAdjust brightslide.value contrastslide.value hueslide.value satuslide.value
			else VCLayerAdjustApply false "" false
		)
		on brightslide changed val do
		(
			brightspin.value = val
			if (previewcheck.state) do VCLayerAdjust brightslide.value contrastslide.value hueslide.value satuslide.value
		)
		on contrastslide changed val do
		(
			contrastspin.value = val
			if (previewcheck.state) do VCLayerAdjust brightslide.value contrastslide.value hueslide.value satuslide.value
		)
		on hueslide changed val do
		(
			huespin.value = val
			if (previewcheck.state) do VCLayerAdjust brightslide.value contrastslide.value hueslide.value satuslide.value
		)
		on satuslide changed val do
		(
			satuspin.value = val
			if (previewcheck.state) do VCLayerAdjust brightslide.value contrastslide.value hueslide.value satuslide.value
		)
		
		on brightspin changed val do
		(
			brightslide.value = val
			if (previewcheck.state) do VCLayerAdjust brightslide.value contrastslide.value hueslide.value satuslide.value
		)
		on contrastspin changed val do
		(
			contrastslide.value = val
			if (previewcheck.state) do VCLayerAdjust brightslide.value contrastslide.value hueslide.value satuslide.value
		)
		on huespin changed val do
		(
			hueslide.value = val
			if (previewcheck.state) do VCLayerAdjust brightslide.value contrastslide.value hueslide.value satuslide.value
		)
		on satuspin changed val do
		(
			satuslide.value = val
			if (previewcheck.state) do VCLayerAdjust brightslide.value contrastslide.value hueslide.value satuslide.value
		)
		on okbut pressed do
		(
			if (not previewcheck.state) do VCLayerAdjust brightslide.value contrastslide.value hueslide.value satuslide.value
			VCLayerAdjustApply true ~ADJUST_LAYER_CAPTION~ false
			hasPressedButton = true
			destroyDialog VCLayerAdjustementDialog
		)
		on cancelbut pressed do
		(
			VCLayerAdjustApply false "" false
			hasPressedButton = true
			destroyDialog VCLayerAdjustementDialog
		)
		on VCLayerAdjustementDialog close do
		(
			if (not hasPressedButton) do VCLayerAdjustApply false "" false
		)
	)
	createDialog VCLayerAdjustementDialog 290 200 modal:true
),
fn OpenBlurDialog =
(
	rollout VCLayerBlurDialog ~BLUR_LAYER~
	(
		local hasPressedButton = false
		spinner blurspin "" fieldwidth:36 type:#integer range:[0,200,20] align:#center offset:[76,0]
		slider blurslide ~AMOUNT~ ticks:0 type:#integer range:[0,200,20] width:240 offset:[0,-20]
		radiobuttons blurradio "" labels:#(~UNIFORM~,~HORIZONTAL~,~VERTICAL~) default:1 columns:1 align:#left offset:[10,10]
		checkbox previewcheck ~PREVIEWCHECK_CAPTION~ checked:true offset:[188,-50]
		button okbut ~OKBUT_CAPTION~ width:60 offset:~OKBUT_OFFSET~
		button cancelbut ~CANCELBUT_CAPTION~ width:60 offset:~CANCELBUT_OFFSET~
		
		fn ApplyBlur =
		(
			hori = blurradio.state < 3
			veri = (blurradio.state == 1 or blurradio.state == 3)
			VCBlurLayer blurslide.value hori veri
		)
		on previewcheck changed state do
		(
			if state then ApplyBlur()
			else VCLayerAdjustApply false "" true
		)
		on blurslide changed val do
		(
			blurspin.value = val
			if (previewcheck.state) do ApplyBlur()
		)
		on blurspin changed val do
		(
			blurslide.value = val
			if (previewcheck.state) do ApplyBlur()
		)
		on blurradio changed state do
		(
			if (previewcheck.state) do ApplyBlur()
		)
		on okbut pressed do
		(
			if (not previewcheck.state) do ApplyBlur()
			VCLayerAdjustApply true ~BLUR_LAYER_CAPTION~ true
			hasPressedButton = true
			destroyDialog VCLayerBlurDialog
		)
		on cancelbut pressed do
		(
			VCLayerAdjustApply false "" true
			hasPressedButton = true
			destroyDialog VCLayerBlurDialog
		)
		on VCLayerBlurDialog open do
		(
			ApplyBlur()
		)
		on VCLayerBlurDialog close do
		(
			if (not hasPressedButton) do VCLayerAdjustApply false "" true
		)
	)
	createDialog VCLayerBlurDialog 280 150 modal:true
),
fn OpenSharpenDialog =
(
	rollout VCLayerSharpenDialog ~SHARPEN_LAYER_CAPTION~
	(
		local hasPressedButton = false
		spinner sharpspin "" fieldwidth:36 type:#float range:[0.0,1.0,0.0] scale:0.01 align:#center offset:[76,0]
		slider sharpslide ~AMOUNT_CAPTION~ ticks:0 type:#float range:[0.0,1.0,0.0] width:240 offset:[0,-20]
		
		spinner radspin "" fieldwidth:36 type:#integer range:[1,200,1] align:#center offset:[76,0]
		slider radslide ~RADIUS_CAPTION~ ticks:0 type:#integer range:[1,200,1] width:240 offset:[0,-20]
		
		spinner threshspin "" fieldwidth:36 type:#integer range:[0,255,0] align:#center offset:[76,0]
		slider threshslide ~THRESHOLD_CAPTION~ ticks:0 type:#integer range:[0,255,0] width:240 offset:[0,-20]
		
		checkbox previewcheck ~CHECKBOX_PREVIEWCHECK_CAPTION~ checked:true offset:[104,8]
		button okbut ~OKBUTTON_CAPTION~ width:60 offset:[90,-24]
		button cancelbut ~CANCELBUTTON_CAPTION~ width:60 offset:[90,0]
		
		fn ApplySharpen =
		(
			VCSharpenLayer radslide.value sharpslide.value threshslide.value
		)
		on previewcheck changed state do
		(
			if state then ApplySharpen()
			else VCLayerAdjustApply false "" true
		)
		on radslide changed val do
		(
			radspin.value = val
			if (previewcheck.state) do ApplySharpen()
		)
		on radspin changed val do
		(
			radslide.value = val
			if (previewcheck.state) do ApplySharpen()
		)
		on sharpslide changed val do
		(
			sharpspin.value = val
			if (previewcheck.state) do ApplySharpen()
		)
		on sharpspin changed val do
		(
			sharpslide.value = val
			if (previewcheck.state) do ApplySharpen()
		)
		on threshslide changed val do
		(
			threshspin.value = val
			if (previewcheck.state) do ApplySharpen()
		)
		on threshspin changed val do
		(
			threshslide.value = val
			if (previewcheck.state) do ApplySharpen()
		)
		on okbut pressed do
		(
			if (not previewcheck.state) do ApplySharpen()
			VCLayerAdjustApply true ~ADJUST_SHARPEN_LAYER_CAPTION~ true
			hasPressedButton = true
			destroyDialog VCLayerSharpenDialog
		)
		on cancelbut pressed do
		(
			VCLayerAdjustApply false "" true
			hasPressedButton = true
			destroyDialog VCLayerSharpenDialog
		)
		on VCLayerSharpenDialog close do
		(
			if (not hasPressedButton) do VCLayerAdjustApply false "" true
		)
	)
	createDialog VCLayerSharpenDialog 280 210 modal:true
),
fn OpenFindEdgesDialog =
(
	rollout VCFindEdgesDialog ~ROLLOUT_FIND_EDGES~
	(
		local hasPressedButton = false
		
		spinner threshspin "" fieldwidth:36 type:#integer range:[0,255,80] align:#center offset:[76,0]
		slider threshslide ~SLIDER_THRESHOLD_CAPTION~ ticks:0 type:#integer range:[0,255,80] width:240 offset:[0,-20]
		
		spinner contrastspin "" fieldwidth:36 type:#float range:[1.0,10.0,1.25] scale:0.01 align:#center offset:[76,0]
		slider contrastslide ~SLIDER_CONTRAST_CAPTION~ ticks:0 type:#float range:[1.0,10.0,1.25] width:240  offset:[0,-20]
		
		checkbox previewcheck ~CHECKBOX_PREVIEWCHECK_CAPTION2~ checked:true offset:[104,8]
		button okbut ~OKBUTTON_CAPTION2~ width:60 offset:[90,-24]
		button cancelbut ~CANCELBUTTON_CAPTION2~ width:60 offset:[90,0]
		
		fn ApplyFindEdges =
		(
			VCFindEdges contrastslide.value threshslide.value
		)
		on previewcheck changed state do
		(
			if state then ApplyFindEdges()
			else VCLayerAdjustApply false "" true
		)
		
		on threshslide changed val do
		(
			threshspin.value = val
			if (previewcheck.state) do ApplyFindEdges()
		)
		on threshspin changed val do
		(
			threshslide.value = val
			if (previewcheck.state) do ApplyFindEdges()
		)
		
		on contrastslide changed val do
		(
			contrastspin.value = val
			if (previewcheck.state) do ApplyFindEdges()
		)
		on contrastspin changed val do
		(
			contrastslide.value = val
			if (previewcheck.state) do ApplyFindEdges()
		)
		
		on okbut pressed do
		(
			if (not previewcheck.state) do ApplyFindEdges()
			VCLayerAdjustApply true ~ROLLOUT_FIND_EDGES2~ true
			hasPressedButton = true
			destroyDialog VCFindEdgesDialog
		)
		on cancelbut pressed do
		(
			VCLayerAdjustApply false "" true
			hasPressedButton = true
			destroyDialog VCFindEdgesDialog
		)
		on VCFindEdgesDialog open do
		(
			ApplyFindEdges()
		)
		on VCFindEdgesDialog close do
		(
			if (not hasPressedButton) do VCLayerAdjustApply false "" true
		)
	)
	createDialog VCFindEdgesDialog 280 160 modal:true
),
fn OpenHighPassDialog =
(
	rollout VCHighPassDialog ~HIGH_PASS_CAPTION~
	(
		local hasPressedButton = false
		spinner radspin "" fieldwidth:36 type:#integer range:[1,200,1] align:#center offset:[76,0]
		slider radslide ~RADIUS_CAPTION2~ ticks:0 type:#integer range:[1,200,1] width:240 offset:[0,-20]
		
		checkbox previewcheck ~CHECKBOX_PREVIEWCHECK_CAPTION3~ checked:true offset:[104,8]
		button okbut ~OKBUTTON_CAPTION3~ width:60 offset:[90,-24]
		button cancelbut ~CANCELBUTTON_CAPTION3~ width:60 offset:[90,0]
		
		fn ApplyHighPass =
		(
			VCHighPass radslide.value
		)
		on previewcheck changed state do
		(
			if state then ApplyHighPass()
			else VCLayerAdjustApply false "" true
		)
		on radslide changed val do
		(
			radspin.value = val
			if (previewcheck.state) do ApplyHighPass()
		)
		on radspin changed val do
		(
			radslide.value = val
			if (previewcheck.state) do ApplyHighPass()
		)
		on okbut pressed do
		(
			if (not previewcheck.state) do ApplyHighPass()
			VCLayerAdjustApply true ~HIGH_PASS_CAPTION2~ true
			hasPressedButton = true
			destroyDialog VCHighPassDialog
		)
		on cancelbut pressed do
		(
			VCLayerAdjustApply false "" true
			hasPressedButton = true
			destroyDialog VCHighPassDialog
		)
		on VCHighPassDialog open do
		(
			ApplyHighPass()
		)
		on VCHighPassDialog close do
		(
			if (not hasPressedButton) do VCLayerAdjustApply false "" true
		)
	)
	createDialog VCHighPassDialog 280 122 modal:true
),
fn OpenJitterDialog =
(
	rollout VCJitterDialog ~DISTORT_CAPTION~
	(
		local hasPressedButton = false
		spinner radspin "" fieldwidth:36 type:#integer range:[0,400,25] align:#center offset:[76,0]
		slider radslide ~OFFSET_CAPTION~ ticks:0 type:#integer range:[0,400,25] width:240 offset:[0,-20]
		
		spinner strenspin "" fieldwidth:36 type:#float range:[0.001,1.0,0.1] scale:0.001 align:#center offset:[76,0]
		slider strenslide ~SCALE_CAPTION~ ticks:0 type:#float range:[0.001,1.0,0.1] width:240 offset:[0,-20]
		
		spinner noisespin "" fieldwidth:36 type:#integer range:[1,100,8] align:#center offset:[76,0]
		slider noiseslide ~ITERATIONS_CAPTION~ ticks:0 type:#integer range:[1,100,8] width:240 offset:[0,-20]
		
		spinner phasespin "" fieldwidth:36 type:#integer range:[0,1000,0] align:#center offset:[76,0]
		slider phaseslide ~PHASE_CAPTION~ ticks:0 type:#integer range:[0,1000,0] width:240 offset:[0,-20]
		
		checkbox previewcheck ~CHECKBOX_PREVIEWCHECK_CAPTION4~ checked:true offset:[104,8]
		button okbut ~OKBUTTON_CAPTION4~ width:60 offset:[90,-24]
		button cancelbut ~CANCELBUTTON_CAPTION4~ width:60 offset:[90,0]
		
		fn ApplyJitter =
		(
			VCJitter radslide.value strenslide.value noiseslide.value phaseslide.value
		)
		on previewcheck changed state do
		(
			if state then ApplyJitter()
			else VCLayerAdjustApply false "" true
		)
		on radslide changed val do
		(
			radspin.value = val
			if (previewcheck.state) do ApplyJitter()
		)
		on radspin changed val do
		(
			radslide.value = val
			if (previewcheck.state) do ApplyJitter()
		)
		on strenslide changed val do
		(
			strenspin.value = val
			if (previewcheck.state) do ApplyJitter()
		)
		on strenspin changed val do
		(
			strenslide.value = val
			if (previewcheck.state) do ApplyJitter()
		)
		
		on noiseslide changed val do
		(
			noisespin.value = val
			if (previewcheck.state) do ApplyJitter()
		)
		on noisespin changed val do
		(
			noiseslide.value = val
			if (previewcheck.state) do ApplyJitter()
		)
		
		on phaseslide changed val do
		(
			phasespin.value = val
			if (previewcheck.state) do ApplyJitter()
		)
		on phasespin changed val do
		(
			phaseslide.value = val
			if (previewcheck.state) do ApplyJitter()
		)
		on okbut pressed do
		(
			if (not previewcheck.state) do ApplyJitter()
			VCLayerAdjustApply true ~JITTER_CAPTION~ true
			hasPressedButton = true
			destroyDialog VCJitterDialog
		)
		on cancelbut pressed do
		(
			VCLayerAdjustApply false "" true
			hasPressedButton = true
			destroyDialog VCJitterDialog
		)
		on VCJitterDialog open do
		(
			ApplyJitter()
		)
		on VCJitterDialog close do
		(
			if (not hasPressedButton) do VCLayerAdjustApply false "" true
		)
	)
	createDialog VCJitterDialog 280 252 modal:true
),
fn OpenMedianDialog =
(
	rollout VCMedianDialog ~MEDIAN_CAPTION~
	(
		local hasPressedButton = false
		spinner radspin "" fieldwidth:36 type:#integer range:[0,100,10] align:#center offset:[76,0]
		slider radslide ~RADIUS_CAPTION3~ ticks:0 type:#integer range:[0,100,10] width:240 offset:[0,-20]
		
		checkbox previewcheck ~CHECKBOX_PREVIEWCHECK_CAPTION5~ checked:true offset:[104,8]
		button okbut ~OKBUTTON_CAPTION5~ width:60 offset:[90,-24]
		button cancelbut ~CANCELBUTTON_CAPTION5~ width:60 offset:[90,0]
		
		fn ApplyMedian =
		(
			VCMedian radslide.value
		)
		on previewcheck changed state do
		(
			if state then ApplyMedian()
			else VCLayerAdjustApply false "" true
		)
		on radslide changed val do
		(
			radspin.value = val
			if (previewcheck.state) do ApplyMedian()
		)
		on radspin changed val do
		(
			radslide.value = val
			if (previewcheck.state) do ApplyMedian()
		)
		on okbut pressed do
		(
			if (not previewcheck.state) do ApplyMedian()
			VCLayerAdjustApply true ~MEDIAN_CAPTION2~ true
			hasPressedButton = true
			destroyDialog VCMedianDialog
		)
		on cancelbut pressed do
		(
			VCLayerAdjustApply false "" true
			hasPressedButton = true
			destroyDialog VCMedianDialog
		)
		on VCMedianDialog open do
		(
			ApplyMedian()
		)
		on VCMedianDialog close do
		(
			if (not hasPressedButton) do VCLayerAdjustApply false "" true
		)
	)
	createDialog VCMedianDialog 280 120 modal:true
),
fn OpenThresholdDialog =
(
	rollout VCThresholdDialog ~THRESHOLD_CAPTION2~
	(
		local hasPressedButton = false
		spinner radspin "" fieldwidth:36 type:#integer range:[0,255,128] align:#center offset:[76,0]
		slider radslide ~SLIDER_THRESHOLD_CAPTION2~ ticks:0 type:#integer range:[0,255,128] width:240 offset:[0,-20]
		
		spinner smoothspin "" fieldwidth:36 type:#integer range:[0,128,0] align:#center offset:[76,0]
		slider smoothslide ~SMOOTHNESS_CAPTION~ ticks:0 type:#integer range:[0,128,0] width:240 offset:[0,-20]
		
		spinner aliasspin "" fieldwidth:36 type:#integer range:[0,128,0] align:#center offset:[76,0]
		slider aliasslide ~GRADIENT_CAPTION~ ticks:0 type:#integer range:[0,128,0] width:240 offset:[0,-20]
		
		checkbox previewcheck ~CHECKBOX_PREVIEWCHECK_CAPTION6~ checked:true offset:[104,8]
		button okbut ~OKBUTTON_CAPTION6~ width:60 offset:[90,-24]
		button cancelbut ~CANCELBUTTON_CAPTION6~ width:60 offset:[90,0]
		
		fn ApplyThreshold =
		(
			VCThreshold radslide.value smoothslide.value aliasslide.value
		)
		on previewcheck changed state do
		(
			if state then ApplyThreshold()
			else VCLayerAdjustApply false "" true
		)
		on radslide changed val do
		(
			radspin.value = val
			if (previewcheck.state) do ApplyThreshold()
		)
		on radspin changed val do
		(
			radslide.value = val
			if (previewcheck.state) do ApplyThreshold()
		)
		
		on smoothslide changed val do
		(
			smoothspin.value = val
			if (previewcheck.state) do ApplyThreshold()
		)
		on smoothspin changed val do
		(
			smoothslide.value = val
			if (previewcheck.state) do ApplyThreshold()
		)
		
		on aliasslide changed val do
		(
			aliasspin.value = val
			if (previewcheck.state) do ApplyThreshold()
		)
		on aliasspin changed val do
		(
			aliasslide.value = val
			if (previewcheck.state) do ApplyThreshold()
		)
		on okbut pressed do
		(
			if (not previewcheck.state) do ApplyThreshold()
			VCLayerAdjustApply true ~THRESHOLD_CAPTION3~ true
			hasPressedButton = true
			destroyDialog VCThresholdDialog
		)
		on cancelbut pressed do
		(
			VCLayerAdjustApply false "" true
			hasPressedButton = true
			destroyDialog VCThresholdDialog
		)
		on VCThresholdDialog open do
		(
			ApplyThreshold()
		)
		on VCThresholdDialog close do
		(
			if (not hasPressedButton) do VCLayerAdjustApply false "" true
		)
	)
	createDialog VCThresholdDialog 280 210 modal:true
),
fn OpenLevelsDialog =
(
	rollout VCLevelsDialog ~LEVELS_CAPTION2~
	(
		local hasPressedButton = false
		spinner blackspin "" fieldwidth:36 type:#integer range:[0,255,0] align:#center offset:[76,0]
		slider blackslide ~SLIDER_BLACK~ ticks:0 type:#integer range:[0,255,0] width:240 offset:[0,-20]
		
		spinner whitespin "" fieldwidth:36 type:#integer range:[0,255,255] align:#center offset:[76,0]
		slider whiteslide ~SLIDER_WHITE~ ticks:0 type:#integer range:[0,255,255] width:240 offset:[0,-20]
		
		spinner midspin "" fieldwidth:36 type:#float range:[-1.0,1.0,0.0] scale:0.01 align:#center offset:[76,0]
		slider midslide ~MID_TONES_OFFSET~ ticks:0 type:#float range:[-1.0,1.0,0.0] width:240 offset:[0,-20]
		
		checkbox previewcheck ~CHECKBOX_PREVIEWCHECK_CAPTION7~ checked:true offset:[104,8]
		button okbut ~OKBUTTON_CAPTION7~ width:60 offset:[90,-24]
		button cancelbut ~CANCELBUTTON_CAPTION7~ width:60 offset:[90,0]
		
		fn ApplyLevels =
		(
			VCAdjustLevels blackslide.value whiteslide.value midslide.value
		)
		on previewcheck changed state do
		(
			if state then ApplyLevels()
			else VCLayerAdjustApply false "" true
		)
		on blackslide changed val do
		(
			blackspin.value = val
			if val > whiteslide.value - 1 do
			(
				blackslide.value = blackspin.value =whiteslide.value - 1
			)
			if (previewcheck.state) do ApplyLevels()
		)
		on blackspin changed val do
		(
			blackslide.value = val
			if val > whiteslide.value - 1 do
			(
				blackslide.value = blackspin.value =whiteslide.value - 1
			)
			if (previewcheck.state) do ApplyLevels()
		)
		on whiteslide changed val do
		(
			whitespin.value = val
			if val < blackslide.value + 1 do
			(
				whiteslide.value = whitespin.value = blackslide.value + 1
			)
			if (previewcheck.state) do ApplyLevels()
		)
		on whitespin changed val do
		(
			whiteslide.value = val
			if val < blackslide.value + 1 do
			(
				whiteslide.value = whitespin.value = blackslide.value + 1
			)
			if (previewcheck.state) do ApplyLevels()
		)
		on midslide changed val do
		(
			midspin.value = val
			if (previewcheck.state) do ApplyLevels()
		)
		on midspin changed val do
		(
			midslide.value = val
			if (previewcheck.state) do ApplyLevels()
		)
		on okbut pressed do
		(
			if (not previewcheck.state) do ApplyLevels()
			VCLayerAdjustApply true ~LEVELS_CAPTION3~ true
			hasPressedButton = true
			destroyDialog VCLevelsDialog
		)
		on cancelbut pressed do
		(
			VCLayerAdjustApply false "" true
			hasPressedButton = true
			destroyDialog VCLevelsDialog
		)
		on VCLevelsDialog close do
		(
			if (not hasPressedButton) do VCLayerAdjustApply false "" true
		)
	)
	createDialog VCLevelsDialog 280 204 modal:true
),
fn OpenColorBalanceDialog =
(
	rollout VCColorBalanceDialog ~COLOR_BALANCE_CAPTION~
	(
		local hasPressedButton = false
		local red1 = 0
		local red2 = 0
		local red3 = 0
		local green1 = 0
		local green2 = 0
		local green3 = 0
		local blue1 = 0
		local blue2 = 0
		local blue3 = 0
		spinner redspin "" fieldwidth:36 type:#integer range:[-100,100,0] align:#center offset:[76,0]
		slider redslide ~CYAN_RED~ ticks:0 type:#integer range:[-100,100,0] width:240 offset:[0,-20]
		
		spinner greenspin "" fieldwidth:36 type:#integer range:[-100,100,0] align:#center offset:[76,0]
		slider greenslide ~MAGENTA_GREEN~ ticks:0 type:#integer range:[-100,100,0] width:240 offset:[0,-20]
		
		spinner bluespin "" fieldwidth:36 type:#integer range:[-100,100,0] align:#center offset:[76,0]
		slider blueslide ~YELLOW_BLUE~ ticks:0 type:#integer range:[-100,100,0] width:240 offset:[0,-20]
		
		radiobuttons toneradio "" labels:#(~SHADOWS~,~MIDTONES~,~HIGHLIGHTS~) default:2 columns:3 offset:[0,4]
		
		checkbox previewcheck ~CHECKBOX_PREVIEWCHECK_CAPTION8~ checked:true offset:[104,12]
		button okbut ~OKBUT_CATION~ width:60 offset:~OKBUT_OFFSET2~
		button cancelbut ~CANCELBUTTON_CAPTION8~ width:60 offset:~CANCELBUT_OFFSET2~
		
		fn ApplyColorBalance =
		(
			VCColorBalance red1 red2 red3 green1 green2 green3 blue1 blue2 blue3
		)
		on toneradio changed state do
		(
			if state == 1 then
			(
				redspin.value = red1
				redslide.value = red1
				greenspin.value = green1
				greenslide.value = green1
				bluespin.value = blue1
				blueslide.value = blue1
			)
			else if state == 2 then
			(
				redspin.value = red2
				redslide.value = red2
				greenspin.value = green2
				greenslide.value = green2
				bluespin.value = blue2
				blueslide.value = blue2
			)
			else
			(
				redspin.value = red3
				redslide.value = red3
				greenspin.value = green3
				greenslide.value = green3
				bluespin.value = blue3
				blueslide.value = blue3
			)
		)
		on previewcheck changed state do
		(
			if state then ApplyColorBalance()
			else VCLayerAdjustApply false "" true
		)
		on redslide changed val do
		(
			redspin.value = val
			if toneradio.state == 1 then red1 = val
			else if toneradio.state == 2 then red2 = val
			else red3 = val
			if (previewcheck.state) do ApplyColorBalance()
		)
		on redspin changed val do
		(
			redslide.value = val
			if toneradio.state == 1 then red1 = val
			else if toneradio.state == 2 then red2 = val
			else red3 = val
			if (previewcheck.state) do ApplyColorBalance()
		)
		
		on greenslide changed val do
		(
			greenspin.value = val
			if toneradio.state == 1 then green1 = val
			else if toneradio.state == 2 then green2 = val
			else green3 = val
			if (previewcheck.state) do ApplyColorBalance()
		)
		on greenspin changed val do
		(
			greenslide.value = val
			if toneradio.state == 1 then green1 = val
			else if toneradio.state == 2 then green2 = val
			else green3 = val
			if (previewcheck.state) do ApplyColorBalance()
		)
		
		on blueslide changed val do
		(
			bluespin.value = val
			if toneradio.state == 1 then blue1 = val
			else if toneradio.state == 2 then blue2 = val
			else blue3 = val
			if (previewcheck.state) do ApplyColorBalance()
		)
		on bluespin changed val do
		(
			blueslide.value = val
			if toneradio.state == 1 then blue1 = val
			else if toneradio.state == 2 then blue2 = val
			else blue3 = val
			if (previewcheck.state) do ApplyColorBalance()
		)
		
		on okbut pressed do
		(
			if (not previewcheck.state) do ApplyColorBalance()
			VCLayerAdjustApply true ~COLOR_BALANCE_CAPTION2~ true
			hasPressedButton = true
			destroyDialog VCColorBalanceDialog
		)
		on cancelbut pressed do
		(
			VCLayerAdjustApply false "" true
			hasPressedButton = true
			destroyDialog VCColorBalanceDialog
		)
		on VCColorBalanceDialog close do
		(
			if (not hasPressedButton) do VCLayerAdjustApply false "" true
		)
	)
	createDialog VCColorBalanceDialog 280 236 modal:true
),
fn OpenLayerDialog =
(
	rollout VCLayerDialog ~LAYERS_CAPTION~
	(
		dropdownlist blendmode "" items:#(~NORMAL~,~DARKEN~,~MULTIPLY~,~COLOR_BURN~,~LINEAR_BURN~,~LIGHTEN~,~SCREEN~,~COLOR_DODGE~,~LINEAR_DODGE~,~OVERLAY~,~SOFT_LIGHT~,~HARD_LIGHT~,~VIVID_LIGHT~,~LINEAR_LIGHT~,~PIN_LIGHT~,~HARD_MIX~,~DIFFERENCE~,~EXCLUSION~,~BLENDMODE_HUE~,~BLENDMODE_SATURATION~,~BLENDMODE_COLOR~,~LUMINOSITY~) selection:1 height:23 width:94 offset:[-2,0]
		spinner opacspin ~OPACSPIN_CAPTION~ range:[0,100,100] type:#integer fieldwidth:36 offset:[-4,-24]
		subRollout theSubRollout "" height:40 width:220 offset:[0,0] align:#center
		
		button duplicatelayerbut ~DUPLICATELAYERBUT_CAPTION~ iconName:"PolyTools/ViewportCanvas/DuplicateLayer" width:38 height:30 align:#left offset:[92,0] tooltip:~DUPLICATELAYERBUT_TOOLTIP~
		button newlayerbut ~NEWLAYERBUT_CAPTION~ iconName:"PolyTools/ViewportCanvas/AddNewLayer" width:38 height:30 align:#left offset:[134,-27] tooltip:~NEWLAYERBUT_TOOLTIP~
		button deletelayerbut ~DELETELAYERBUT_CAPTION~ iconName:"PolyTools/ViewportCanvas/DeleteLayer" width:38 height:30 align:#left offset:[176,-27] tooltip:~DELETELAYERBUT_TOOLTIP~
		
		on blendmode selected num do
		(
			VCLayerSettingChangeStart ~LAYER_BLENDING_MODE_CHANGE~ --create undo entry
			VCSetLayerSetting 5 0 num
		)
		on opacspin buttondown do
		(
			VCLayerSettingChangeStart ~LAYER_OPACITY_CHANGE_CAPTION~ --create undo entry
		)
		on opacspin changed val do VCSetLayerSetting 4 0 val
		on duplicatelayerbut pressed do VCDuplicateLayer()
		on newlayerbut pressed do VCNewLayer()
		on deletelayerbut pressed do VCDeleteLayer()
		on VCLayerDialog open do
		(
			currentGamma = IDisplayGamma.colorCorrectionMode
			IDisplayGamma.colorCorrectionMode = #none
		
			--VCLayers.LayerVisibleBitmap = undefined
			if (VCLayers.LayerVisibleBitmap == undefined) do
			(
				VCLayers.LayerVisibleBitmap = openbitmap (VCanvas.brushDir + "LayerVisible.tif")
				VCLayers.LayerEmptyBitmap = openbitmap (VCanvas.brushDir + "LayerEmpty.tif")
				VCLayers.LayerSelectedBitmap = openbitmap (VCanvas.brushDir + "LayerSelected.tif")
			)
			
			if (VCGetSetting 100) do -- if pating is active
			(
				VCSetLayerSetting 9 0 true --set layerdialog as open setting
				
				VCLayers.BuildLayerRollout()
				numLayers = VCGetLayerSetting 1 0
				if numLayers > 3 do
				(
					newHeight = 220 + ((numLayers - 3) * 37)
					if newHeight > (sysInfo.desktopSize.y - 400) do newHeight = sysInfo.desktopSize.y - 400
					if newHeight < VCLayers.LayerDialogSize.y do  newHeight = VCLayers.LayerDialogSize.y
					VCLayerDialog.height = newHeight
				)
				addSubRollout VCLayerDialog.theSubRollout VCLayerRollout
				diagSize = GetDialogSize VCLayerDialog
				VCLayerDialog.theSubRollout.height = diagSize.y - 70
				VCSetLayerSetting 3 0 false --turn off layer mask painting
				for i = 1 to numLayers do
				(
					VCLayers.SetLayerImage i false false
				)
				
				--Put in the fill bitmap between each layer which is visible when reordering layers by dragging
				if (LayerFillBitmap == undefined) do
				(
					if (colorMan.colorTheme == #dark) then LayerFillBitmap = bitmap 200 1 color:[255,255,255]
					else LayerFillBitmap = bitmap 200 1 color:[70,70,70]
				)
				controls = VCLayerRollout.controls
				for i = 1 to controls.count do 
				(
					cont = VCLayerRollout.controls[i]
					if (classof cont == BitmapControl) do VCLayerRollout.controls[i].bitmap = LayerFillBitmap
				)
				
				minpos = theSubRollout.height + 28
				bottompos = diagsize.y - 38
				if bottompos < minpos then newpos = minpos
				else newpos = bottompos
				duplicatelayerbut.pos.y = newpos
				newlayerbut.pos.y = newpos
				deletelayerbut.pos.y = newpos
				
				VCLayers.UpdateLayerUI()
			)
			if (VCLayers.LayerDialogDockState != #cui_floatable) do
			(
				if (not VCLayerDialog.dialogBar) do
				(
					VCLayers.LayerDialogHeightBeforeDock = (getDialogSize VCLayerDialog).y
					VCLayerDialog.height = VCLayers.GetViewHeight() + 22
					cui.RegisterDialogBar VCLayerDialog style:#(#cui_floatable, #cui_dock_horz) minSize:[220,100] maxSize:[220,1600]
				)
				cui.DockDialogBar VCLayerDialog LayerDialogDockState
			)
			IDisplayGamma.colorCorrectionMode = currentGamma
		)
		on VCLayerDialog close do
		(
			VCLayers.LayerDialogPos = getDialogPos VCLayerDialog
			VCSetLayerSetting 9 0 false --set dialog closed setting
		)
			
		on VCLayerDialog resized size do
		(
			diagsize = getDialogSize VCLayerDialog
			VCLayers.LayerDialogSize = diagsize
			theSubRollout.height = diagSize.y - 70
			minpos = theSubRollout.height + 28
			bottompos = diagsize.y - 38
			if bottompos < minpos then newpos = minpos
			else newpos = bottompos
			duplicatelayerbut.pos.y = newpos
			newlayerbut.pos.y = newpos
			deletelayerbut.pos.y = newpos
		)
		on VCLayerDialog moved pos do
		(
			VCLayers.LayerDialogPos = getDialogPos VCLayerDialog
		)
	)
	createDialog VClayerDialog VCLayers.LayerDialogSize.x VCLayers.LayerDialogSize.y VCLayers.LayerDialogPos.x VCLayers.LayerDialogPos.y lockWidth:true style:#(#style_toolwindow,#style_sysmenu,#style_resizing,#style_titlebar) menu:VCLayerMenu
),
fn CloseLayerDialog =
(
	if VCLayerDialog.dialogBar do
	(
		if ((cui.getDockState VCLayerDialog) != #cui_floatable) then
		(
			cui.FloatDialogBar VCLayerDialog
			cui.UnRegisterDialogBar VCLayerDialog
			VCLayerDialog.height = VCLayers.LayerDialogHeightBeforeDock
		)
		else cui.unRegisterDialogBar VClayerDialog
	)
	destroyDialog VCLayerDialog
)
) -- end VCLayerStruct

VCLayers = VCLayerStruct()

